-- new script file
function OnAfterSceneLoaded(self)
  CreateTriggerSources(self)
end

function OnThink(self)
  if not self.initialized then
    self.initialized = true
    self.shallows:LinkToTarget("questShallows")
    self.p0 = Citadels.GetPlayer(0)
    self.active = true
end
  
  if self.active then
    CheckForPlayer(self)
  end
end

function OnBeforeDeath(self)
  self.shallows:TriggerAllTargets()
end

function CheckForPlayer(self)
  p0units = self.p0:UnitsInRadiusNumber(self:GetPosition(), 2000, '*')
  
  if p0units > 1 then
    self.p0:AddQuest('D01_SHALLOWS', 'side')
    self.active = false
  end
end

function OnSerialize(self, ar)
  if (ar:IsLoading()) and Citadels.GetLoadGameRunning() then
    CreateTriggerSources(self)
    self.loaded = true
  end
end

function CreateTriggerSources(self)
  self:AddTriggerSource("shallows")
end
